#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_RowVersionException : BaseTest 
	{
		private string exceptionText = System.DateTime.Now.ToString();
		

		[Test]
		public void Ctor_String_Pass()
		{
			try
			{
				throw new Common.RowVersionException(exceptionText);
			}
			catch (Common.RowVersionException ex)
			{
				Assert.AreEqual(exceptionText, ex.Message);
			}
		}

		[Test]
		public void Ctor_String_Fail()
		{
            Assert.Throws < Common.RowVersionException> (
                    delegate { throw new Common.RowVersionException(null); });

				
			
		}
	}

}
#endif
